#
# SQL Export
# Created by Querious (201026)
# Created: December 15, 2019 at 10:03:32 PM GMT+8
# Encoding: Unicode (UTF-8)
#


SET @PREVIOUS_FOREIGN_KEY_CHECKS = @@FOREIGN_KEY_CHECKS;
SET FOREIGN_KEY_CHECKS = 0;


DROP TABLE IF EXISTS `doc`;
DROP TABLE IF EXISTS `book`;
DROP TABLE IF EXISTS `api_statistics`;


CREATE TABLE `api_statistics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `app` varchar(20) DEFAULT NULL COMMENT '应用名',
  `v` varchar(20) DEFAULT NULL COMMENT '版本',
  `module` varchar(20) DEFAULT NULL COMMENT '模块',
  `action` varchar(20) DEFAULT NULL COMMENT '动作',
  `date` varchar(20) DEFAULT NULL COMMENT '日期，不带时间',
  `hour` int(2) DEFAULT NULL COMMENT '小时，24小时制',
  `count` int(11) DEFAULT '0' COMMENT '计数器',
  `updatetime` bigint(11) DEFAULT NULL COMMENT '最后更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='api调用统计表';


CREATE TABLE `book` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `book_id` bigint(20) NOT NULL COMMENT '仓库id',
  `type` varchar(50) DEFAULT NULL COMMENT '类型 [Book - 文档]',
  `slug` varchar(50) DEFAULT NULL COMMENT '仓库路径',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `namespace` varchar(100) NOT NULL COMMENT '仓库完整路径 user.login/book.slug',
  `user_id` bigint(20) DEFAULT NULL COMMENT '所属的团队/用户编号',
  `toc` text,
  `toc_yml` text COMMENT '目录原文',
  `description` text COMMENT '介绍',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人 User Id',
  `public` tinyint(2) DEFAULT NULL COMMENT '公开状态 [1 - 公开, 0 - 私密]',
  `item_count` int(11) DEFAULT NULL COMMENT '文档数量',
  `likes_count` int(11) DEFAULT NULL COMMENT '喜欢数量',
  `watches_count` int(11) DEFAULT NULL COMMENT '订阅数量',
  `created_at` datetime DEFAULT NULL COMMENT '创建时间',
  `updated_at` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8;


CREATE TABLE `doc` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `doc_id` bigint(20) NOT NULL,
  `slug` varchar(50) NOT NULL,
  `title` varchar(100) DEFAULT NULL,
  `book_id` bigint(11) DEFAULT NULL,
  `book_namespace` varchar(50) DEFAULT NULL,
  `book_slug` varchar(50) DEFAULT NULL,
  `book_name` varchar(50) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `body_markdown` text,
  `body_lake` text,
  `body_html` text,
  `creator_id` bigint(20) DEFAULT NULL,
  `public` tinyint(2) DEFAULT NULL,
  `status` tinyint(2) DEFAULT NULL,
  `likes_count` int(11) DEFAULT NULL,
  `comments_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tags` text,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3892 DEFAULT CHARSET=utf8;




SET FOREIGN_KEY_CHECKS = @PREVIOUS_FOREIGN_KEY_CHECKS;


SET @PREVIOUS_FOREIGN_KEY_CHECKS = @@FOREIGN_KEY_CHECKS;
SET FOREIGN_KEY_CHECKS = 0;


LOCK TABLES `api_statistics` WRITE;
ALTER TABLE `api_statistics` DISABLE KEYS;
ALTER TABLE `api_statistics` ENABLE KEYS;
UNLOCK TABLES;


LOCK TABLES `book` WRITE;
ALTER TABLE `book` DISABLE KEYS;
ALTER TABLE `book` ENABLE KEYS;
UNLOCK TABLES;


LOCK TABLES `doc` WRITE;
ALTER TABLE `doc` DISABLE KEYS;
ALTER TABLE `doc` ENABLE KEYS;
UNLOCK TABLES;




SET FOREIGN_KEY_CHECKS = @PREVIOUS_FOREIGN_KEY_CHECKS;


